//
//  TabController.swift
//  Orbis
//
//  Created by KALSI on 6/22/17.
//  Copyright © 2017 KALSI. All rights reserved.
//

import UIKit
import AudioToolbox
import UserNotifications

class TabController: UIViewController, UNUserNotificationCenterDelegate {

    @IBOutlet weak var bottomBar: UIView!
    @IBOutlet weak var pinkView: UIView!

    @IBOutlet weak var tabView1: UIView!
    @IBOutlet weak var tabView2: UIView!
    @IBOutlet weak var tabView3: UIView!
    @IBOutlet weak var tabView4: UIView!
    @IBOutlet weak var tabView5: UIView!
    
    @IBOutlet weak var container: UIView!
    @IBOutlet weak var alarmImage: UIImageView!
    
    @IBOutlet weak var signals: UIImageView!
    @IBOutlet weak var stopRedBtn: UIView!
    
    let identifierList = ["Dashboard", "MyLocation", "RedAlert", "MyMessage", "FallDetect", "AmberAlert"]
    
    weak var currentViewController: UIViewController?
    var storyboardId = String()
    var Aframe = CGRect()
    var Rframe = CGRect()
    var redTimer = Timer()
    
    //MARK:-
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
        
        //View Attributes
        let Y = -2 - (pinkView.frame.size.width - bottomBar.frame.size.height)
        pinkView.frame =  CGRect(x: pinkView.frame.origin.x, y:Y , width: pinkView.frame.size.width, height: pinkView.frame.size.width)
        pinkView.layer.cornerRadius = pinkView.frame.size.width / 2
        
        Globals.properties().shadow(view: pinkView, placement: CGPoint(x: 0, y: 0), pathType: Constants.kRoundBezierPath, cornerRadius: pinkView.frame.size.width)
        Globals.properties().shadow(view: bottomBar, placement: CGPoint(x: 0, y: -1), pathType: Constants.kRectangleBezierPath)
        if !appDelegate.isBluetooth{

        bottomBar.isHidden = false
        }

    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        storyboardId = "Dashboard"
        initialContainerController()
        
      
        
     //   if appDelegate.isRedForAmber{
//            print("isRedForAmbertrue")
//            let stopLong = UILongPressGestureRecognizer(target: self, action: #selector(self.StopRedForAmber(recognizer:)))
//            stopLong.minimumPressDuration = 0.8
//            pinkView.addGestureRecognizer(stopLong)

//        }else{
            let pressLong = UILongPressGestureRecognizer(target: self, action: #selector(self.StartRed(recognizer:)))
            pressLong.minimumPressDuration = 0
            pinkView.addGestureRecognizer(pressLong)
            
            let stopLong = UILongPressGestureRecognizer(target: self, action: #selector(self.StopRed(recognizer:)))
            stopLong.minimumPressDuration = 0
            stopRedBtn.addGestureRecognizer(stopLong)

//        }
        
        //Notifications
        NotificationCenter.default.addObserver(self, selector: #selector(self.tabShift(notify:)), name: NSNotification.Name("tabShift"), object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(self.tabColorShiftRed(notify:)), name: NSNotification.Name("tabColorShiftRed"), object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(self.BottomBarColorReset), name: NSNotification.Name("tabColorShiftReset"), object: nil)
        
        //Local Notifications
        UNUserNotificationCenter.current().requestAuthorization(options: [[.alert, .sound, .badge]], completionHandler: { (granted, error) in
            // Handle Error
        })
        UNUserNotificationCenter.current().delegate = self
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    
    //MARK:-
    
    func StopRedForAmber(recognizer : UILongPressGestureRecognizer) {
        print("StopRedForAmber")
            NotificationCenter.default.post(name: NSNotification.Name("stopRedAmber"), object: nil)
    
    }
    func StopRed(recognizer : UILongPressGestureRecognizer) {
        if recognizer.state == UIGestureRecognizerState.began {
            NotificationCenter.default.post(name: NSNotification.Name("RedBegan"), object: nil)
        }
        if recognizer.state == .ended {
            NotificationCenter.default.post(name: NSNotification.Name("RedEnded"), object: nil)
        }
    }
    func StartRed(recognizer : UILongPressGestureRecognizer) {
        
        if recognizer.state == .began {
            print("began")
            self.redTimer.invalidate()
            signals.isHidden = false
            self.signals.image = UIImage(named: "sig1")
            AudioServicesPlayAlertSound(SystemSoundID(kSystemSoundID_Vibrate))
            var x = 0
            redTimer = Timer.scheduledTimer(withTimeInterval: 1, repeats: true, block: { (ticktick) in
                x += 1
                print(x)
                if x == 0{
                    self.signals.image = UIImage(named: "sig1")
                }else if x == 1{
                    self.signals.image = UIImage(named: "sig2")
                }else if x == 2{
                    self.signals.image = UIImage(named: "sig3")
                }
                
                if x >= 3{
                    let dict = [
                        "datetime":"",
                        "imei":"",
                        "number":"",
                        "messageType":"AMST",
                        "lat":"",
                        "long":"",
                        "posdatatime":"",
                        "postype":"gps",
                        "status":"",
                        "interval":"",
                        "speed":""
                    ]
//                    Globals.Services().AlamofireGet(method: "signals/", parameters: dict as NSDictionary, completion: { (result) in
//                        
//                    }, failure: { (fail) in
//                        
//                    })
                    self.signals.isHidden = true
                    self.redTimer.invalidate()
                    if self.storyboardId != "RedAlert"{
                        self.storyboardId = "RedAlert"
                    }
                    self.stopRedBtn.isHidden = false
                    self.loadViewController_withIdentifier(identifier: self.storyboardId)
                    self.bottomBar.isUserInteractionEnabled = false
                }
            })
        }
        
        if recognizer.state == .ended{
            print("ended or changed")
            signals.isHidden = true
            self.redTimer.invalidate()
        }
    }
    
    func tabShift(notify : Notification) {

        let tagged = notify.object
        let tabButton = UIButton()
        tabButton.tag = tagged as! Int
        self.TabActions(tabButton)
    }
    func tabColorShiftRed(notify : Notification) {
        tabView1.alpha = 1
        tabView2.alpha = 1
        tabView3.alpha = 1
        tabView4.alpha = 1
        tabView5.alpha = 1
        
        tabView1.backgroundColor = Constants.cRedActivated
        tabView2.backgroundColor = Constants.cRedActivated
        tabView3.backgroundColor = Constants.cRedActivated
        tabView4.backgroundColor = Constants.cRedActivated
        tabView5.backgroundColor = Constants.cRedActivated
    }
    func ResetBottomBarAlpha() {
        tabView1.alpha = 0.8
        tabView2.alpha = 0.8
        tabView3.alpha = 0.8
        tabView4.alpha = 0.8
        tabView5.alpha = 0.8
    }
    func BottomBarColorReset() {
        ResetBottomBarAlpha()
        tabView1.backgroundColor = Constants.cRedDeactivated
        tabView2.backgroundColor = Constants.cRedDeactivated
        tabView3.backgroundColor = Constants.cRedDeactivated
        tabView4.backgroundColor = Constants.cRedDeactivated
        tabView5.backgroundColor = Constants.cRedDeactivated
        
        stopRedBtn.isHidden = true
        bottomBar.isUserInteractionEnabled = true
        bottomBar.isHidden = false

        loadViewController_withIdentifier(identifier: "Dashboard")
        tabView1.alpha = 1
    }
    
    //MARK:- Container View Funcitons -
    func initialContainerController() {
        self.currentViewController = self.storyboard?.instantiateViewController(withIdentifier: "Dashboard")
        self.currentViewController!.view.translatesAutoresizingMaskIntoConstraints = false
        self.addChildViewController(self.currentViewController!)
        self.addSubview(subView: self.currentViewController!.view, toView: container)
    }
    func loadViewController_withIdentifier(identifier : String) {
        let newViewController = self.storyboard?.instantiateViewController(withIdentifier: identifier)
        newViewController!.view.translatesAutoresizingMaskIntoConstraints = false
        self.cycleFromViewController(oldViewController: self.currentViewController!, toViewController: newViewController!)
        self.currentViewController = newViewController
    }
    func addSubview(subView:UIView, toView parentView:UIView) {
        parentView.addSubview(subView)
        var viewBindingsDict = [String: AnyObject]()
        viewBindingsDict["subView"] = subView
        parentView.addConstraints(NSLayoutConstraint.constraints(withVisualFormat: "H:|[subView]|",
                                                                 options: [], metrics: nil, views: viewBindingsDict))
        parentView.addConstraints(NSLayoutConstraint.constraints(withVisualFormat: "V:|[subView]|",
                                                                 options: [], metrics: nil, views: viewBindingsDict))
    }
    func cycleFromViewController(oldViewController: UIViewController, toViewController newViewController: UIViewController) {
        oldViewController.willMove(toParentViewController: nil)
        self.addChildViewController(newViewController)
        if !(container.subviews).contains(newViewController.view){
            
            self.addSubview(subView: newViewController.view, toView:container)
        
            
        }

    
        newViewController.view.layoutIfNeeded()
        UIView.animate(withDuration: 0.5, animations: {
            
//            newViewController.view.layoutIfNeeded()
        },
                       completion: { finished in
                        oldViewController.view.removeFromSuperview()
                        oldViewController.removeFromParentViewController()
                        newViewController.didMove(toParentViewController: self)
        })
    }
    
    //MARK:- IBActions -
    @IBAction func TabActions(_ sender: UIButton) {
        ResetBottomBarAlpha()
        self.view.viewWithTag((sender.tag) * 10)?.alpha = 1
        if sender.tag == 3 {
            //Red Alert
        //bottomBar.isUserInteractionEnabled = false
            
        bottomBar.isHidden = true

        }
        if appDelegate.isBluetooth{
            bottomBar.isHidden = true

        }
        print(storyboardId)

        print(identifierList[sender.tag - 1])
        
//        if storyboardId != identifierList[sender.tag - 1]{
            storyboardId = identifierList[sender.tag - 1]
          if storyboardId != ""{
                self.loadViewController_withIdentifier(identifier: storyboardId)
            }
        //}
    }
    
    //MARK:- Local Notification -
    func userNotificationCenter(_ center: UNUserNotificationCenter, willPresent notification: UNNotification, withCompletionHandler completionHandler: @escaping (UNNotificationPresentationOptions) -> Void) {
        completionHandler([.alert, .sound])
    }

}
